#include <stdio.h>
#include "util.h"

#define PI_LEN 200000000

void generate2(int m, int n, int seed, long start, long interval) {
	unsigned long mon = binomial_coef(n+2, 2);
	
	printf("Galois Field : GF(2)\n"); 
	printf("Number of variables (n) : %d\n", n); 
	printf("Number of polynomials (m) : %d\n", m); 
	printf("Seed : %d\n", seed);
	printf("Order : graded reverse lex order\n"); 
	printf("\n*********************\n");

	long pos = start;
	for (int i = 0; i < m; i++){
		for (unsigned long j = 0; j < mon-1; j++) {
			printf("%d ", readPI(pos, 1));
			pos += interval;
                        pos %= PI_LEN;
		}	
		printf("0 ;\n");
	}
}

void generate256(int m, int n, int seed, long start, long interval) {
        unsigned long mon = binomial_coef(n+2, 2);
	char map16[] = "0123456789abcdef"; 
        
        printf("Galois Field : GF(2)[x] / x^8 + x^4 + x^3 + x^2 + 1\n");
        printf("Number of variables (n) : %d\n", n); 
        printf("Number of polynomials (m) : %d\n", m);
	printf("Seed : %d\n", seed);
        printf("Order : graded reverse lex order\n");
        printf("\n*********************\n");

	long pos = start;
        for (int i = 0; i < m; i++){
                for (unsigned long j = 0; j < mon-1; j++) {
                        printf("%c%c ", map16[readPI(pos, 4)], map16[readPI(pos+4, 4)]);
			pos += interval;
                        pos %= PI_LEN;
                }       
                printf("00 ;\n");
        }
}

void generate31(int m, int n, int seed, long start, long interval) {
        unsigned long mon = binomial_coef(n+2, 2);
        
        printf("Galois Field : GF(31)\n");
        printf("Number of variables (n) : %d\n", n); 
        printf("Number of polynomials (m) : %d\n", m);
	printf("Seed : %d\n", seed);
        printf("Order : graded reverse lex order\n");
        printf("\n*********************\n");

	long pos = start;
	int coef;
        for (int i = 0; i < m; i++){
                for (unsigned long j = 0; j < mon-1; j++) {
			coef = readPI(pos, 5);
                        while (coef == 31) {
                                pos += interval;
                                pos %= PI_LEN;
                                coef = readPI(pos, 5);
                        }
			printf("%d ", coef);
			pos += interval;
                        pos %= PI_LEN;
                }       
                printf("0 ;\n");
        }
}
