#include <stdint.h>

template <typename T>
T binomial_coef(T n, T k) {
    T i;
    T b;
    if (0 == k || n == k) {
        return 1;
    }
    if (k > n) {
        return 0;
    }
    if (k > (n - k)) {
        k = n - k;
    }
    if (1 == k) {
        return n;
    }
    b = 1;
    for (i = 1; i <= k; ++i) {
        b *= (n - (k - i));
        if (b < 0) return -1; /* Overflow */
        b /= i;
    }
    return b;
}

int readPI(long pos, int bit) {
        FILE *PI = fopen("PI", "r");
        int input = 0;

        if (PI==NULL) {
                printf("Error opening random source file PI.");
                return 0;
        }
        fseek(PI, pos, SEEK_SET);

        for (int i = 0; i < bit; i++) {
                input*=2;
                input += fgetc(PI)-'0'?1:0;
        }

        fclose(PI);
        return input;
}
